;RS232_AutoBaud, Automatische Erkennung der Baudrate
;Empfangen und Senden mit 1200..19200 Baud bei 1,2 MHz

     .include "tn13def.inc"

    .def   A      = r16
    .def   Delay  = r17
    .def   Count  = r18
    .def   Time   = r19	
    .def   Time2  = r20	

    ;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2

        rjmp Anfang
Anfang:
        sbi   ddrb,TXD	;Datenrichtung TXD
        clr   Time
Puls1:                  ;Pulslnge messen			
        sbis  pinb,RXD  ;Empfangen
        rjmp  Puls1
Puls2:
        inc   Time      ;1		 
        sbic  pinb,RXD  ;1
        rjmp  Puls2     ;2
        subi  Time, 5   ;-20 Takte
        mov   Time2,Time
        ror   Time2

Schleife:
        rcall  RdCOM
        rcall  WrCOM
        rjmp   Schleife

Wait1:	;Eine Bitlnge warten
		mov   Delay,Time  ;+1
Wait1b:
        nop               ;1
        dec   Delay       ;1
        brne  Wait1b      ;2
        ret               ;+4
        
Wait2:	;1/2 Bitlnge warten
        mov   Delay,Time2
Wait2b:
        dec Delay
        brne  Wait2b
        ret 

RdCOM:	sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        rcall Wait1  
        rcall Wait2  
        ldi   A,0
        ldi   Count,8
L1:     lsr   A          ;1
        sbic  pinb,RXD   ;1/2
        ori   A,128      ;2
        rcall Wait1      ;3 + 5 + 4*Time
        nop              ;1
        nop              ;1
        nop              ;1
        nop              ;1
        dec   Count      ;1
        brne  L1         ;2, ...=19
        rcall Wait1
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        rcall Wait1 
        ldi   Count,8
L2:     sbrc  A,0         ;1 
        rjmp  OFF         ;2
        rjmp  ONt
ONt:    sbi   portb,TXD
        rjmp  BitD
OFF:    cbi   portb,TXD   ;2
        rjmp  BitD        ;2 
BitD:   rcall Wait1       ;3 + 5 + 4*Time
        lsr   A           ;1
        dec   Count       ;1 
        brne  L2          ;2, ...=19
        cbi   PORTB,TXD
        rcall Wait1
        ret

