;Frequenz.asm, Frequenzmessung an PB4

    .include "tn13def.inc"

    .def   A      = r16
    .def   timer  = r17
    .def   timer2 = r18
    .def   sek    = r19
    .def   sicher = r20
    .def   freqlow   = r21
    .def   freqhigh  = r22
    .def   Delay  = r23
    .def   Count  = r24

    ;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2


        rjmp Anfang
        .org 0x0003 
        rjmp TIM0_OVF    ;Timer0 Overflow 
Anfang:
        sbi    ddrb,TXD    
        sbi    ddrb,3    
        ldi    A,3        ;Start mit Vorteiler / 64
        out    TCCR0B,A
        ldi    A,2
        out    TIMSK0,A	   ;Timer Interrupt freigeben
Schleife:
        clr    timer2
        clr    sek
        clr    freqlow
        clr    freqhigh
        sei                ;Interrupt freigeben   
Z1:     sbic   pinb,4        
        rjmp   Z2
        sbi    portb,3     ;Testsignal
        cpi    sek,1
        brsh   Z4
        rjmp   Z1
Z2:     sbis   pinb,4
        rjmp   Z3
        cbi    portb,3     ;Testsignal
        cpi    sek,1
        brsh   Z4
        rjmp   Z2
Z3:     inc    freqlow
        brne   Z4
        inc    freqhigh
Z4:     cpi    sek,1
        brlo   Z1
Z5:     cli                ;Interrupt sperren
        mov    A,freqhigh
        rcall  WrCOM
        mov    A,freqlow
        rcall  WrCOM
        rjmp   Schleife


TIM0_OVF:                  ;Timer Interrupt
        in    sicher, SREG 
        ldi   timer, 6 
        out   TCNT0,timer  ;250 bis Overflow
;		sbis  pinb,3
;        rjmp  B3a
;        cbi   portb,3
;        rjmp  B3b
;B3a:    sbi   portb,3        
;B3b:
        inc   timer2
        cpi   timer2,75
        brlo  TIM0_ende
        clr   timer2
        inc   sek
TIM0_ende:
        out   SREG,sicher
        reti

RdCOM:  sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        ldi   Delay,58  
D1:     dec   Delay
        brne  D1
        ldi   A,0
        ldi   Count,8
L1:     lsr   A
        sbic  pinb,RXD
        ori   A,128
        ldi   Delay, 38  
D2:     dec   Delay
        brne  D2
        dec   Count
        brne  L1
        ldi   Delay, 38
D3:     dec   Delay
        brne  D3
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        ldi   Delay,38 
D4:     dec   Delay
        brne  D4
        ldi   Count,8
L2:     sbrc  A,0
        rjmp  OFF
        rjmp  ON
ON:     sbi   portb,TXD
        rjmp  BitD
OFF:    cbi   portb,TXD
        rjmp  BitD
BitD:   ldi   Delay,38  
D5:     dec   Delay
        brne  D5
        lsr   A
        dec   Count
        brne  L2
        cbi   PORTB,TXD
        ldi   Delay,38  
D6:     dec   Delay
        brne  D6
        ret
